#include <iostream>
#include <vector>
#include <algorithm>
#include <climits>
using namespace std;

struct Jarbol {
    long long x;
    long long h;
    int indeks;
};

int main() {
    int n;
    cin>>n;
    vector<long long> udaljenosti(n);
    vector<long long> visine(n);
    for(int i=0;i<n;i++) 
        cin>>udaljenosti[i];
    for(int i=0;i<n;i++) 
        cin>>visine[i];
    //Jarboli sortirani po x koordinati
    vector<Jarbol> jarboli(n);
    for(int i=0;i<n;i++)
        jarboli[i]={udaljenosti[i],visine[i],i};
    
    sort(jarboli.begin(),jarboli.end(),[](Jarbol a,Jarbol b){
        return a.x<b.x;
    });

    vector<long long> rezultat(n,-1);

    for (int i=0;i<n;i++) {
        long long x_i=jarboli[i].x;
        long long h_i=jarboli[i].h;
        long long najbolja=LLONG_MAX;

        //Provera svih drugih jarbola
        for (int j=0;j<n;j++) {
            if (i==j) 
                continue;
            long long x_j=jarboli[j].x;
            long long h_j=jarboli[j].h;

            //Ako je drugi jarbol dovoljno visok
            if(h_j>=h_i){
                long long rastojanje=llabs(x_i-x_j);
                najbolja=min(najbolja,rastojanje);
            }
        }

        if (najbolja==LLONG_MAX) 
            rezultat[jarboli[i].indeks]=-1;
        else rezultat[jarboli[i].indeks]=najbolja;
    }

    for (int i=0;i<n;i++) {
        cout<<rezultat[i]<<"\n";
    }
    return 0;
}